/**
 * \file: libsugc_set.h
 *
 * \brief : Functions to perform actual configuration
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef LIBSUGC_SET
#define LIBSUGC_SET

/**
 * \defgroup libsugc_set_api libsugc internal API to apply the config or a fallback config
 */

#include <libsugc.h>
#include "libsugc_config.h"

/**
 * \ingroup libsugc_set_api
 * \brief Apply the fallback configuration
 *
 * This function will try its very best to set as much of the fallback
 * configuration as possible.
 * In case of error the errors will be logged and the sequence is continued
 */
void libsugc_set_fallback_config(void);

/**
 * \ingroup libsugc_set_api
 * \brief Set user/group/supplementary groups and capabilities according to configuration
 *
 * \param[in] config        \ref libsugc_config_t struct specifing user/group/supplementary groups and capabilities
 *
 * \return \ref libsugc_error_t
 */
libsugc_error_t libsugc_apply_config(const libsugc_config_t *config);

#endif
